## Recommendation-stopping pairs (RSP).

# GLRT
struct GLRT
    threshold;
end

long(rsp::GLRT) = "GLRT " * rsp.threshold;
abbrev(rsp::GLRT) = "G-" * rsp.threshold;


# Lazy GLRT with decreasing geometric rate)
struct LazyGLRT
    threshold;
    T0::Int64;
    alpha::Float64;
    Tmax::Base.RefValue{Int64};
    LazyGLRT(threshold, T0, alpha) = new(threshold, T0, alpha, Ref(T0));
end

long(rsp::LazyGLRT) = "LGLRT " * rsp.threshold;
abbrev(rsp::LazyGLRT) = "LG-" * rsp.threshold;
new_phase!(rsp::LazyGLRT, t) = rsp.Tmax[] = Int64(floor(t * (1 + rsp.alpha / sqrt(1 + log(t)))));
Tmax(rsp::LazyGLRT) = rsp.Tmax[];

function compute_GLR(rsp::LazyGLRT, t, is_subopt)
    if is_subopt || (t >= Tmax(rsp))
        new_phase!(rsp, t);
        true;
    else
        false;
    end
end
